<?php
/*======================================================================*\
|| #################################################################### ||
|| # v3 Arcade                                                          ||
||                                         ||
||                            ((3ssom.com/vb))                          ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'arcade');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array();

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// ############################ NO ACTION ################################

if (!$_GET['do'] && !$_POST['sessdo'] && !$_POST['do']) {
	$_GET['do'] = "main";
}

// ########################### EDIT COMMENTS #############################
if ($_GET['do'] == "editcomment") {
	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_editcomment'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');
	
	$navbits = array("arcade.php?$session[sessionurl]" => "");
	$navbits[""] = " ";
	
	if ($arcadepermissions['caneditscores']==0) {
		print_no_permission();
	} 
	if (isset($_GET['id'])) {
		$sessionid = intval($_GET['id']);
		$comment = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "gamesessions WHERE sessionid=$sessionid LIMIT 1");
		$comment['comment'] = htmlspecialchars($comment['comment']);
		eval('$arcadebody = "' . fetch_template('arcade_editcomment') . '";');
	}
	$DB_site->free_result($comment);
}
// ########################## DO EDIT COMMENTS ############################
if ($_POST['do'] == "doeditcomment") {
	// pre-cache templates used by all actions
	$globaltemplates = array();
	require_once('./global.php');
	require_once('./includes/functions_newpost.php');
		
	if ($arcadepermissions['caneditscores']==0) {
		print_no_permission();
	}
	globalize($_POST, array('sessionid'=>INT, 'do'=>STR_NOHTML, 'limit'=>INT, 'gamename'=>STR_NOHTML, 'comment'=>STR_NOHTML));
	$comment_un = unhtmlspecialchars($_POST['comment']);
	$DB_site->query("UPDATE " . TABLE_PREFIX . "gamesessions SET comment='".addslashes($comment_un)."' WHERE sessionid=$sessionid");
	
	$url = "arcade.php?do=scores&name=$gamename";
	if ($_POST['page']) {
		$pagenumber = intval($_POST['page']);
		$url .= "&page=".$pagenumber;
	}
	eval(print_standard_redirect('redirect_updatethanks'));
}


// ########################### DELETE COMMENTS #############################
if ($_GET['do'] == "deletecomment") {
	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_deletecomment'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');
	
	$navbits = array("arcade.php?$session[sessionurl]" => "");
	$navbits[""] = " ";
	
	if ($arcadepermissions['candelscores']==0) {
		print_no_permission();
	} 
	if (isset($_GET['id'])) {
		$sessionid = intval($_GET['id']);
		$sessioncheck = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "gamesessions WHERE sessionid=$sessionid");
		$sessionresults = $DB_site->num_rows($sessioncheck);
		if ($sessionresults == 1) {
			eval('$arcadebody = "' . fetch_template('arcade_deletecomment') . '";');
		} else {
			print_no_permission();
		}
	} else {
		print_no_permission();
	}
	$DB_site->free_result($sessioncheck);
}
// ########################## DO DELETE COMMENTS ############################
if ($_POST['do'] == "dodeletecomment") {
	// pre-cache templates used by all actions
	$globaltemplates = array();

	require_once('./global.php');
	if ($arcadepermissions['candelscores']==0) {
		print_no_permission();
	}
	globalize($_POST, array('sessionid'=>INT, 'do'=>STR_NOHTML, 'limit'=>INT, 'gamename'=>STR_NOHTML, 'deletecheck'=>INT));
	
	if ($_POST['deletecheck']==1) {
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "gamesessions WHERE sessionid=$sessionid");
	}
	$url = "arcade.php?do=scores&name=$gamename";
	if ($_POST['page']) {
		$pagenumber = intval($_POST['page']);
		$url .= "&page=".$pagenumber;
	}
	eval(print_standard_redirect('redirect_updatethanks'));
}


// ######################### MAIN ARCADE PAGE ############################
if ($_GET['do'] == "main") {
	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_main',
		'arcade_main_alerts',
		'arcade_main_alerts_bit',
		'arcade_main_games_bit',
		'arcade_main_news',
		'arcade_main_news_bit',
		'arcade_main_welcome'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');
	
	if ($arcadegeneral['challengescores'] == 1) {
		$sessionclause = "sessiontype IN (1,2)";
	} else {
		$sessionclause = "sessiontype=1";
	}
	
	$navbits = array();
	$navbits[""] = "";
	
	// creates a $gamesettings array, usage $gamesettings[gamename]
	$result_gamesettings = $DB_site->query("SELECT gameid, shortname, gamesettings, title FROM " . TABLE_PREFIX . "games");
	while ($gameset = $DB_site->fetch_array($result_gamesettings)) {
		$gamesettings["$gameset[shortname]"] = convert_bits_to_array($gameset[gamesettings],$_GAMESCHECK);
		$namecache["$gameset[shortname]"]['title'] = $gameset['title'];
		$namecache["$gameset[shortname]"]['id'] = $gameset['gameid'];
	}
	$DB_site->free_result($result_gamesettings);

	if ($bbuserinfo['userid'] == 0) {
		eval('$welcomeblock = "' . fetch_template('arcade_main_guest') . '";');
	} else {
		// if this is the user's first visit to the arcade
		if ($arcadeuser['firstvisit'] == 1) {
			$arcadeintro = "     , ".$bbuserinfo['username']."!";
			eval('$welcomeblock = "' . fetch_template('arcade_main_welcome') . '";');
			
			// query that registers the user's first arcade visit
			$DB_site->query("
				UPDATE " . TABLE_PREFIX . "user 
				SET arcadesettings = arcadesettings-1 
				WHERE userid=$bbuserinfo[userid]
			");
			
		} else {
			// Checks for any pending challenges
			$result_pending = $DB_site->query("
				SELECT gamechallenges.*, user.username, user.userid, games.title, user2.username AS username2, user2.userid AS userid2 FROM " . TABLE_PREFIX . "gamechallenges AS gamechallenges
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON gamechallenges.challengerid = user.userid
				LEFT JOIN " . TABLE_PREFIX . "user AS user2 ON gamechallenges.challengedid = user2.userid
				LEFT JOIN " . TABLE_PREFIX . "games AS games ON gamechallenges.game = games.shortname
				WHERE (challengedid=$bbuserinfo[userid] 
				AND gamechallenges.status=0) OR (challengerid=$bbuserinfo[userid] 
				AND gamechallenges.status=2)
			");
			$pending_challenges = $DB_site->num_rows($result_pending);
			
			if ($pending_challenges > 0) {
				while($chall = $DB_site->fetch_array($result_pending)) {
					if ($chall['status']==0) {
						$challengebits .= "<tr><td align=\"left\"> <a href=\"member.php?u=$chall[userid]\"><strong>$chall[username]</strong></a>       <strong>$chall[title]</strong>!<br><div align='center'><font size=1>     </font></div></td><td>&nbsp;&nbsp;<a href=\"arcade.php?do=acceptchallenge&id=$chall[challengeid]\"><img src=\"$stylevar[imgdir_arcade]/accept.gif\" border=0 alt=\"   \" align=\"absmiddle\"></a> <a href=\"arcade.php?do=declinechallenge&id=$chall[challengeid]\"><img src=\"$stylevar[imgdir_arcade]/decline.gif\" alt=\"  \" border=0 align=\"absmiddle\"></a></td></tr>";
					} else {
						$challengebits .= "<tr><td align=\"left\"> <a href=\"member.php?u=$chall[userid2]\"><strong>$chall[username2]</strong></a>     <strong>$chall[title]</strong> !<br><div align='center'><font size=1>     !</font></div></td><td>&nbsp;&nbsp;<a href=\"arcade.php?do=acceptchallenge&id=$chall[challengeid]\"><img src=\"$stylevar[imgdir_arcade]/accept.gif\" border=0 alt=\"  \" align=\"absmiddle\"></a> <img src=\"$stylevar[imgdir_arcade]/decline_g.gif\" alt=\"\" border=0 align=\"absmiddle\"></td></tr>";
					}
				}
				$ischallengepending = 1;
				$alertheader = " !";
				$alerticon = "alert";
				if ($pending_challenges == 1) {
					$chaltext = " !";
				} else {
					$chaltext = "  ";
				}
				$alerttext = "  ".$pending_challenges." ".$chaltext;
			} else {

				$latestscore = $DB_site->query_first("
					SELECT gamesessions.*,user.username FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
					LEFT JOIN " . TABLE_PREFIX . "user AS user ON gamesessions.userid = user.userid
					WHERE gamesessions.valid=1 AND gamesessions.$sessionclause ORDER BY gamesessions.finish DESC LIMIT 0,1
				");

				$latestscore['title'] = $namecache["$latestscore[gamename]"]['title'];
				$latestscore['gameid'] = $namecache["$latestscore[gamename]"]['id'];
				
				$alertheader = "   ";
				$alerticon = "arrow";
				$alerttext = construct_phrase($vbphrase['arcade_main_latestscorebit'],$latestscore['username'],$latestscore['score'],$latestscore['title'],$latestscore['gameid']);
				if (empty($latestscore['username'])) {
					$alertheader = "    ";
					$alerttext = "       ";
				}
				$DB_site->free_result($latestscore);
			}
			$DB_site->free_result($result_pending);
			$arcadeintro = "    , <strong>$bbuserinfo[username]</strong>!<br>
			<font size=1>     ..   !<br>&nbsp;</font>";
			
			// In bit format for future expansions
			eval('$alertbits .= "' . fetch_template('arcade_main_alerts_bit') . '";');
			// Main alert template
			eval('$arcadealerts = "' . fetch_template('arcade_main_alerts') . '";');
			// Center "welcome block"
			eval('$welcomeblock = "' . fetch_template('arcade_main_welcome') . '";');
		}
	}

		$avatar = fetch_avatar_url($bbuserinfo[userid]);
	if ($avatar != "") {		
		$bbuserinfo['avatar'] = "<img src=\"".$avatar."\" border=0>";
	} else {
		$bbuserinfo['avatar'] = "<img src=\"$stylevar[imgdir_arcade]/noavatar.gif\" border=0>";
	}
	
	// New arrays are declared
	$scoredgames = array();
	$nonscoredgames = array();
	$where = array();
	$playedcounter = array();
	
	$newsresult = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "gamenews ORDER BY datestamp DESC LIMIT 4");
	while ($news = $DB_site->fetch_array($newsresult)) {
		$news['time'] = vbdate($vboptions['dateformat'],$news['datestamp'],true);
		exec_switch_bg();
		eval('$newsbits .= "' . fetch_template('arcade_main_news_bit') . '";');
	}
	$DB_site->free_result($newsresult);
	eval('$arcadenews = "' . fetch_template('arcade_main_news') . '";');
	
	// Personal bests - returns PB in form of an array, $personalBest[shortname]
	$personalBest = array();
	$result_pb = $DB_site->query("
		SELECT gamename, MAX(score) AS score FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
		WHERE valid=1 AND $sessionclause
		AND userid=$bbuserinfo[userid] 
		GROUP BY gamename
	");
	while ($bestArray = $DB_site->fetch_array($result_pb)) {
		$personalBest[$bestArray[gamename]] = $bestArray[score];
	}
	$DB_site->free_result($result_pb);

	// Query selects all the top scores from the database
	$result_topscores = $DB_site->query("
		SELECT gamename, MAX(score) AS score, COUNT(valid=1) AS played FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
		WHERE valid=1 AND $sessionclause
		GROUP BY gamename
	");
		
	// While loop, where part of an SQL query is constructed
	while ($thesession = $DB_site->fetch_array($result_topscores))
	{
		$where[] = "(gamename='$thesession[gamename]' AND score='$thesession[score]')";
		$playedcounter[$thesession[gamename]] = $thesession['played'];
	}
	$DB_site->free_result($result_topscores);
	// Query built
	if(!empty($where)) {
		$whereclause = "WHERE ".implode(' OR ', $where);
	}
	
	// Query to get the other data for the high scores
	$result_topscore2 = $DB_site->query("
		SELECT gamesessions.*, user.username, user.userid, games.*, games.title AS title FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON user.userid = gamesessions.userid
		LEFT JOIN " . TABLE_PREFIX . "games AS games ON gamesessions.gamename = games.shortname
		$whereclause AND $sessionclause ORDER BY gamesessions.gamename DESC
	");
	
	// While loop constructs the $gamebits variable, with games where scores have been recorded
	while ($game = $DB_site->fetch_array($result_topscore2)) {
		$gamecache["$game[shortname]"] = $game;
		$gamecache["$game[shortname]"]['played'] = $playedcounter["$game[shortname]"];
	}
		
	$DB_site->free_result($result_topscore2);
	
	if (!empty($_REQUEST['search']))
	{
		globalize($_REQUEST, array('search'=>STR_NOHTML));
		$searchstring = "&search=$search";
		$searchclause = "WHERE (title LIKE '%" . addslashes($search) . "%' OR descr LIKE '%" . addslashes($search) . "%')";
	}

	// Selects all games from the database
	$result_allgames = $DB_site->query("
		SELECT * FROM " . TABLE_PREFIX . "games $searchclause ORDER BY gameid DESC
	");
	
	$gamecount = $DB_site->num_rows($result_allgames);
	if ($gamecount == 0) {
		exec_switch_bg();
		eval('$gamebits .= "' . fetch_template('arcade_main_noresults') . '";');
	}
	
	$perpage = 10;
	$pagenumber = $_REQUEST['page'];
	if (empty($pagenumber)) $pagenumber = 1;
	$startingfrom = ($pagenumber*$perpage)-$perpage;
	$upperlimit = $startingfrom + $perpage;
	
	$g = 0;
	// Gets all of the games
	while ($game = $DB_site->fetch_array($result_allgames)) {
		$gamename = $game['shortname'];
		if ($gamecache["$game[shortname]"]) {
			$game = $gamecache["$game[shortname]"];
		} else {
			// the game has never had a score recorded
			// $extra is used as a conditional for the arcade_main_games_bit template
			$extra = 1;
		}
		if (strlen($game['username'])>12) {
			$game['username'] = "<font size=1>".$game['username']."</font>";
		}
		if (($game['gamesettings'] & 1)&&($g >= $startingfrom && $g<$upperlimit)) {
			eval('$gamebits .= "' . fetch_template('arcade_main_games_bit') . '";');
			exec_switch_bg();
		}
		if ($game['gamesettings'] & 1) {
			$g++;
		}
		unset($extra);
	}
	
	$DB_site->free_result($result_allgames);
	
	$g++;
	$pagenav = construct_page_nav($g, "arcade.php?$session[sessionurl]do=main$searchstring");

	// Main page content
	eval('$arcadebody = "' . fetch_template('arcade_main') . '";');
			
}


// ############################ HIGH SCORES ################################
if ($_GET['do']=="scores") {

	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_scores',
		'arcade_scores_bit'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');
	
	// the "setnum" variable is the number of scores to show on each page
	$setnum = 10;

	if ($arcadegeneral['challengescores'] == 1) {
		$sessionclause = "sessiontype IN (1,2)";
	} else {
		$sessionclause = "sessiontype=1";
	}

	$navbits = array("arcade.php?$session[sessionurl]" => "");
	$navbits[""] = " ";

	// requires bbcode parsing functions for comments
	require_once('./includes/functions_bbcodeparse.php');
	
	// if no game name is specified, shows nopermission
	if (!$_GET['name']) {
		print_no_permission();
	}
	globalize($_GET, array('name'=>STR, 'userid'=>INT));
	
	$game = $DB_site->query_first("
		SELECT * FROM " . TABLE_PREFIX . "games
		WHERE shortname='" . addslashes($name) . "'
	");	
	

	$result_scores = $DB_site->query("
		SELECT gamesessions.sessionid FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
		WHERE valid=1 AND gamename='" . addslashes($name) . "' AND $sessionclause
	");
	$scores = $DB_site->num_rows($result_scores);

	// score sets
	if (!$_GET['set']) {
		$set = "1";
		$setlabel = " ";
	}
	
	if ($_GET['set'] == "2") {
		$setlabel = "   ";
		$scoreOldDate = mktime()-604800;
		$scoreSQL .= "AND gamesessions.finish>$scoreOldDate";
		$address2 = "&amp;set=2";
	}
	
	if ($_GET['userid']) {
		$scoreSQL .= " AND gamesessions.userid=$userid";
	}
	
	$perpage = $setnum;
	$pagenumber = intval($_GET['page']);
	if (!$pagenumber){
		$pagenumber = 1;
	}
	sanitize_pageresults($scores, $pagenumber, $setnum);
	$navigation = construct_page_nav($scores, "arcade.php?$session[sessionurl]do=scores&name=$name",$address2);


	$limit = ($pagenumber*$setnum)-$setnum;
	$DB_site->free_result($result_scores);

	$placeCounter = $limit+1;
	if ($arcadegeneral['highonly'] == 1) {
		$query_scorefetch = "SELECT DISTINCT user.username, gamesessions.sessionid, gamesessions.gamename, gamesessions.userid, gamesessions.start, gamesessions.finish, gamesessions.comment, gamesessions.sessiontype, MAX(gamesessions.score) AS score FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
							LEFT JOIN " . TABLE_PREFIX . "user AS user ON user.userid=gamesessions.userid
							WHERE valid=1 AND gamesessions.$sessionclause AND gamename='$game[shortname]'$scoreSQL
							GROUP BY gamesessions.userid
							ORDER BY score
							DESC LIMIT $limit, $setnum";
	} else {
		$query_scorefetch = "SELECT gamesessions.*, user.username FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
							LEFT JOIN " . TABLE_PREFIX . "user AS user ON user.userid=gamesessions.userid
							WHERE gamesessions.valid=1 AND gamesessions.$sessionclause AND gamesessions.gamename='$game[shortname]'$scoreSQL
							ORDER BY score 
							DESC LIMIT $limit, $setnum";
	}

	$scoreResults[2] = $DB_site->query($query_scorefetch);
	while ($score = $DB_site->fetch_array($scoreResults[2])) {
		if ($placeCounter == 1) {
				$avatar = fetch_avatar_url($score[userid]);
				$leaderAvatar = "<img src=\"".$avatar."\" border=0>";
		}
		
		$score['comment'] = parse_bbcode2($score['comment'], 0, $arcadegeneral['imgcodeon'], $arcadegeneral['smilieson'], $arcadegeneral['vbcodeon'], 0, 0);
		if ($arcadegeneral['vbcodeon'] == 0) {
			$score['comment'] = strip_bbcode($score['comment']);
		}
		
		// Calculates the session's length
		$score['sessionlength'] = ($score['finish']-$score['start']);
		$scoreDate = vbdate("g:ia M j",$score['finish']);
		exec_switch_bg();
		if (strlen($score[username])>12) {
			$score['username'] = "<font size=1>".$score['username']."</font>";
		}
		eval('$scorebits .= "' . fetch_template('arcade_scores_bit') . '";');
		$placeCounter++;
	}	
	$DB_site->free_result($scoreResults[2]);
	eval('$arcadebody = "' . fetch_template('arcade_scores') . '";');
}



// ############################ PLAY PAGE ################################
if ($_GET['do']=="play") {

	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_play'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');

	if ($arcadegeneral['challengescores'] == 1) {
		$sessionclause = "sessiontype IN (1,2)";
	} else {
		$sessionclause = "sessiontype=1";
	}


	// Checks to see if GET variables are valid
	globalize($_GET, array('gameid'=>INT, 'do'=>STR_NOHTML));
	$gameid = $_GET['gameid'];
	
	// creates a $gamesettings array, usage $gamesettings[gamename]
	$result_gamesettings = $DB_site->query("SELECT gameid, shortname, gamesettings FROM " . TABLE_PREFIX . "games");
	while ($gameset = $DB_site->fetch_array($result_gamesettings)) {
		$gamesettings[$gameset[shortname]] = convert_bits_to_array($gameset[gamesettings],$_GAMESCHECK);
	}
	$DB_site->free_result($result_gamesettings);
		
	$dudcount = $DB_site->query("
		SELECT * FROM " . TABLE_PREFIX . "gamechallenges 
		WHERE (challengedid=$bbuserinfo[userid] AND status=10 AND (type=3 OR type=2)) OR (challengerid=$bbuserinfo[userid] AND status=20 AND (type=5 OR type=4))
	");
	$numduds = $DB_site->num_rows($dudcount);
	if ($numduds!=0) {
		$dudprune = $DB_site->fetch_array($dudcount, DBARRAY_ASSOC);
		if (($dudprune['status']==20 && $dudprune['type']==5)||($dudprune['status']==20 && $dudprune['type']==4)) {
			$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET status=3, type=5 WHERE challengeid=$dudprune[challengeid]");
		}
		if (($dudprune['status']==10 && $dudprune['type']==3)||($dudprune['status']==10 && $dudprune['type']==2)) {
			$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET status=2, type=3 WHERE challengeid=$dudprune[challengeid]");
		}
	}
	$DB_site->free_result($dudcount);

	// Stops unauthorised users from gaining access to the arcade
	if (($arcadegeneral['quickreg']==1)&&($bbuserinfo['userid']==0)) {
		eval(print_standard_error('error_quickreg_prompt'));
	}
	
	// Prints the "no permission" page if gameid doesn't exist, isn't valid,
	// or if the user's usergroup has no permission
	if ($gameid == 0 || !$gameid || $arcadepermissions['canplayarcade']==0) {
		print_no_permission();
	}
	
	$thisGame = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "games WHERE gameid=$gameid");
	
	$navbits = array("arcade.php?$session[sessionurl]" => "");
	$navbits[""] = "$thisGame[title]";
	
	if ($gamesettings[$thisGame[shortname]]['active'] == 0) {
		print_no_permission();
	}
	$highsession = $DB_site->query_first("SELECT gamesessions.*, user.username FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
											LEFT JOIN " . TABLE_PREFIX . "user AS user ON user.userid=gamesessions.userid
											WHERE valid=1 AND gamename='$thisGame[shortname]' AND $sessionclause
											ORDER BY score 
											DESC LIMIT 1");
	eval('$arcadebody = "' . fetch_template('arcade_play') . '";');
	$DB_site->free_result($thisGame);
}

// ############################ NEW SESSION ##############################
if ($_POST['sessdo'] == "sessionstart") {

// pre-cache templates used by all actions
$globaltemplates = array();
require_once('./global.php');
require_once('./includes/functions_user.php');
require_once('./includes/functions_arcade.php');


// Checks to see if current user can play in the arcade
	if ($arcadepermissions['canplayarcade']==0) {
		exit;
	}

	// globalize checks for the gamename entered, converts to $shortname
	globalize($_POST, array('gamename'=>STR_NOHTML));
	$shortname = $_POST['gamename'];
	
	// Checks to see if the game exists, and blows them away if it doesn't
	$gameCheckResult = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "games WHERE shortname='$shortname'");
		if ($DB_site->num_rows($gameCheckResult) != 1) {
			exit;
		}
	$DB_site->free_result($gameCheckResult);
	// Random numbers and current timestamp
	$gamerand = rand(1,10);
	$gametime = mktime();

	$validcount = $DB_site->query("
		SELECT * FROM " . TABLE_PREFIX . "gamechallenges 
		WHERE (challengedid=$bbuserinfo[userid] AND status=10 AND type=2)
		OR (challengerid=$bbuserinfo[userid] AND status=20 AND type=4)
	");
	$num_valid = $DB_site->num_rows($validcount);
	if ($num_valid>=1) {
		$challenge = $DB_site->fetch_array($validcount, DBARRAY_ASSOC);
		$challengeSQL = $challenge['challengeid'];
		$sessiontype=2;
		if ($challenge['status']==20 && $challenge['type']==4) {
			$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET type=5 WHERE challengeid=$challenge[challengeid]");
		}
		if ($challenge['status']==10 && $challenge['type']==2) {
			$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET type=3 WHERE challengeid=$challenge[challengeid]");
		}
	} else {
		$sessiontype=1;
		$challengeSQL = "NULL";
	}
	$DB_site->free_result($validcount);
	// Query - creates empty gaming session
	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "gamesessions (sessionid,gamename,userid,start,sessiontype,challengeid) VALUES ('','$shortname','$bbuserinfo[userid]','$gametime',$sessiontype,$challengeSQL)");
	$lastid = mysql_insert_id();
	
	// Send out variable string to Flash
	echo "&connStatus=1&initbar=$gamerand&gametime=$gametime&lastid=$lastid&result=OK";
	echo "<META HTTP-EQUIV=Refresh CONTENT=\"0; URL=".$vboptions['bburl']."/arcade.php\">";
	exit;
}

// ############################ PERMISSION REQUEST #############################
if ($_POST['sessdo'] == "permrequest") {

	// pre-cache templates used by all actions
	$globaltemplates = array();
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');


	// Checks to see if current user can play in the arcade
	if ($arcadepermissions['canplayarcade']==0) {
		exit;
	}
	
	globalize($_POST, array('note'=>STR_NOHTML, 'id'=>INT, 'gametime'=>INT, 'score'=>STR_NOHTML, 'key'=>INT));
	
	// Turn negative globalize results into errors
	if ($_POST['note'] == 0 || $_POST['id'] == 0 || $_POST['gametime'] == 0  || $_POST['fakekey'] == 0) {
		exit;
	}
	
	// ridiculous and lax slowdown method
	$note = $_POST['note'];
	$id = $_POST['id'];
	$sesstime = $_POST['gametime'];
	$key = $_POST['fakekey'];
	$score = $_POST['score'];
	$ceilscore = ceil($_POST['score']);
	
	$noteid = $note/($key*$ceilscore);
	if ($noteid != $id) {
		echo "&validate=0";
		exit;
	}
	
	$validcount = $DB_site->query("
		SELECT * FROM " . TABLE_PREFIX . "gamechallenges 
		WHERE (challengedid=$bbuserinfo[userid] AND status=10 AND type=3)
		OR (challengerid=$bbuserinfo[userid] AND status=20 AND type=5)
	");
	$num_valid = $DB_site->num_rows($validcount);
	if ($num_valid==1) {
		$challenge = $DB_site->fetch_array($validcount, DBARRAY_ASSOC);
		if ($challenge['status']==20 && $challenge['type']==5) {
			$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET status=3 WHERE challengeid=$challenge[challengeid]");
		}
		if ($challenge['status']==10 && $challenge['type']==3) {
			$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET status=2 WHERE challengeid=$challenge[challengeid]");
		}
	}
	$DB_site->free_result($validcount);
	// Gets accurate timestamp
	$microone = getmicrotime();
	$currenttime = mktime();
	$DB_site->query_first("UPDATE " . TABLE_PREFIX . "gamesessions SET score='$score',finish=$currenttime WHERE sessionid=$id AND start=$sesstime AND userid=$bbuserinfo[userid]");
	echo "&validate=1&microone=$microone&result=OK";
	exit;
}

// ############################ BURN SESSION #############################
if ($_POST['sessdo'] == "burn") {
	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_scores',
		'arcade_scores_bit',
		'arcade_challenge_confirmation',
		'arcade_pm'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');

	globalize($_POST, array('id'=>INT));

	// Checks to see if current user can play in the arcade
	if ($arcadepermissions['canplayarcade']==0 || $bbuserinfo['userid']==0) {
		exit;
	}

	// This query gets all the information about the session, and the game which was played
	$game = $DB_site->query_first("SELECT gamesessions.*, games.* FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
						LEFT JOIN " . TABLE_PREFIX . "games AS games ON games.shortname=gamesessions.gamename
						WHERE sessionid=$id
						AND userid=$bbuserinfo[userid] LIMIT 1");

	if (empty($game) || empty($_POST['id'])) {
		print_no_permission();
	}
		
	if ($arcadegeneral['challengescores'] == 1) {
		$sessionclause = "sessiontype IN (1,2)";
	} else {
		$sessionclause = "sessiontype=1";
	}
			
	// requires bbcode parsing functions for comments
	require_once('./includes/functions_bbcodeparse.php');


	$placeCounter = 1;
	$setnum = 10;
	$difference = sprintf('%.1f',(getmicrotime()-$_POST['microone'])/2*1000);
	
	// pings greater than 4500ms don't count
	if ($difference > 4500) {
		$validatesession = 0;
	} else {
		$validatesession = 1;
	}
	
	// the burn update
	$DB_site->query("UPDATE " . TABLE_PREFIX . "gamesessions SET ping='$difference',valid=$validatesession WHERE sessionid=$_POST[id] AND userid=$bbuserinfo[userid]");



	if ($game['challengeid']!='') {
	
		$navbits = array("arcade.php?$session[sessionurl]" => "");
		$navbits[""] = " ";
	
		$validcount = $DB_site->query("
			SELECT gamechallenges.*, user.username, user.userid, games.title, games.shortname, user2.username AS username2, user2.userid AS userid2, score FROM " . TABLE_PREFIX . "gamechallenges AS gamechallenges
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON gamechallenges.challengerid = user.userid
			LEFT JOIN " . TABLE_PREFIX . "user AS user2 ON gamechallenges.challengedid = user2.userid
			LEFT JOIN " . TABLE_PREFIX . "gamesessions AS session ON session.sessionid=gamechallenges.challengedsession
			LEFT JOIN " . TABLE_PREFIX . "games AS games ON gamechallenges.game = games.shortname
			WHERE gamechallenges.challengeid=$game[challengeid]
		");
		if ($DB_site->num_rows($validcount)==1) {
			$challenge = $DB_site->fetch_array($validcount, DBARRAY_ASSOC);
			
			if ($arcadegeneral['challengescores'] == 1) {
				$position = $DB_site->query_first("
					SELECT COUNT(*) + 1 AS position
					FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
					WHERE score > $game[score] AND valid=1 AND gamesessions.gamename='$challenge[shortname]'
				");
				if ($position['position']==1) {
					$DB_site->query("UPDATE " . TABLE_PREFIX . "games SET highscore=$game[score],highscorerid=$bbuserinfo[userid] WHERE shortname='$challenge[shortname]'");
					if ($game['highscorerid']!=$bbuserinfo['userid']) {
						$newstext = addslashes($bbuserinfo['username']."      ".$challenge[title]." ");
						$DB_site->query("INSERT INTO " . TABLE_PREFIX . "gamenews (newstext,newstype,datestamp) VALUES('$newstext','newchamp',".mktime().")");
					}
				}
			}
			
			if ($challenge['status']==2) {
				$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET challengedsession=$_POST[id] WHERE challengeid=$game[challengeid]");
				
				$chal['title'] = $bbuserinfo['username']."      ".$challenge['title']."!";
				$arcadepm = 1;
				eval('$pmmessage .= "' . fetch_template('arcade_pm') . '";');

				sendarcadepm($challenge['userid'],$challenge['username'],$bbuserinfo['userid'],$bbuserinfo['username'],$chal['title'],$pmmessage);		
			
			} elseif ($challenge['status']==3) {
				$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET challengersession=$_POST[id] WHERE challengeid=$game[challengeid]");
				
				if($challenge['score']<$game['score']) {
					$winner=$challenge['username'];
				} elseif ($challenge['score']>$game['score']) {
					$winner=$challenge['username2'];
				} else {
					$winner=" ";
				}
				
				if (empty($challenge['score'])) {
					$challenge['score']='0';
				}
	
				$chal['title'] = $challenge['username']."' ".$challenge['title']."   -  .....";
				$arcadepm = 2;
				eval('$pmmessage .= "' . fetch_template('arcade_pm') . '";');
				sendarcadepm($challenge['userid2'],$challenge['username2'],$bbuserinfo['userid'],$bbuserinfo['username'],$chal['title'],$pmmessage);		
			
			}
			
			eval('$arcadebody .= "' . fetch_template('arcade_challenge_confirmation') . '";');
			eval('print_output("' . fetch_template('ARCADE') . '");');
			$DB_site->free_result($validcount);
		}
	} else {
	
		$scoreResults[2] = $DB_site->query("SELECT gamesessions.*, user.username FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
								LEFT JOIN " . TABLE_PREFIX . "user AS user ON user.userid=gamesessions.userid
								WHERE valid=1 AND gamesessions.$sessionclause AND gamename='$game[shortname]'$scoreSQL
								ORDER BY score 
								DESC LIMIT $setnum");
		while ($score = $DB_site->fetch_array($scoreResults[2])) {

			if ($placeCounter == 1) {
					$avatar = fetch_avatar_url($score[userid]);
					$leaderAvatar = "<img src=\"".$avatar."\" border=0>";
			}
			
			if ($score['sessionid'] == $_POST['id']) {
				$highScore = $placeCounter;
			}
			
			$score['comment'] = parse_bbcode2($score['comment'], 0, $arcadegeneral['imgcodeon'], $arcadegeneral['smilieson'], $arcadegeneral['vbcodeon'], 0, 0);
			
			if ($arcadegeneral['vbcodeon'] == 0) {
				$score['comment'] = strip_bbcode($score['comment']);
			}
	
			// Calculates the session's length
			$score['sessionlength'] = ($score['finish']-$score['start']);
			$scoreDate = vbdate("g:ia M j",$score['finish']);
			exec_switch_bg();
			if (strlen($score[username])>12) {
				$score['username'] = "<font size=1>".$score['username']."</font>";
			}
			eval('$scorebits .= "' . fetch_template('arcade_scores_bit') . '";');
			$placeCounter++;
		}
		$DB_site->free_result($scoreResults[2]);
		
		// Deletes existing pointless records
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "gamesessions WHERE userid=$bbuserinfo[userid] AND valid=0");
		
		if ($highScore > 0) {
			$setlabel = "    !";
		} else {
			$setlabel = " ";
			$game['sessionlength'] = ($game['finish']-$game['start']);

			$position = $DB_site->query_first("
				SELECT COUNT(*) + 1 AS scoresAbove 
				FROM " . TABLE_PREFIX . "gamesessions 
				WHERE score > $game[score] AND valid=1 AND gamename='$game[shortname]'
			");
			$placeCounter = $position['scoresAbove'];
			exec_switch_bg();
			if (strlen($score[username])>12) {
				$score['username'] = "<font size=1>".$score['username']."</font>";
			}
			eval('$scorebits .= "' . fetch_template('arcade_scores_bit') . '";');
		}
		$DB_site->free_result($position);
		
		// Email notification for being knocked off the top spot
		if ($highScore == 1) {
			$result_second = $DB_site->query_first("
				SELECT games.title, gamesessions.score, user.arcadesettings, user.userid, user.username, user.email FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON user.userid = gamesessions.userid
				LEFT JOIN " . TABLE_PREFIX . "games AS games ON gamesessions.gamename = games.shortname
				WHERE gamename='$game[shortname]' 
				AND valid=1 AND $sessionclause
				ORDER BY score DESC 
				LIMIT 1, 1");
				$DB_site->query("UPDATE " . TABLE_PREFIX . "games SET highscore=$game[score],highscorerid=$bbuserinfo[userid] WHERE shortname='$game[shortname]'");
			if ($result_second['userid'] != $bbuserinfo['userid']) {
				$seconduser = convert_bits_to_array($result_second['arcadesettings'],$_ARCADEUSER);
				if ($seconduser['allowemails'] == 1) {
					eval('$subject = "' . fetch_template('arcade_email_beatensubject') . '";');
					eval('$pmmessage = "' . fetch_template('arcade_email_beatenbody') . '";');
					if ($arcadegeneral['allowemail']==1) {
						vbmail($result_second['email'], $subject, $pmmessage, true);
					}
				}
				$DB_site->free_result($result_second);
				// adds a news item
				$newstext = addslashes($bbuserinfo['username']."      ".$game[title]." ");
				$DB_site->query("INSERT INTO " . TABLE_PREFIX . "gamenews (newstext,newstype,datestamp) VALUES('$newstext','newchamp',".mktime().")");
			}
		}
		$navbits = array("arcade.php?$session[sessionurl]" => "");
		$navbits[""] = " ";
		eval('$arcadebody = "' . fetch_template('arcade_scores') . '";');
	}
}

// ############################ BURN COMMENT ################################
if ($_POST['sessdo'] == "burncomment") {

	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');
	
	globalize($_POST, array('shortname' => STR_NOHTML));

	$lastsession = $DB_site->query_first("
		SELECT * FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
		WHERE gamename='$shortname'
		AND userid=$bbuserinfo[userid] 
		AND valid=1
		ORDER BY finish DESC LIMIT 1
	");
	
	// if there isn't already a comment for the score
	if ($lastsession['comment'] == "No Comment") {
		$_POST['comment'] = trim(addslashes($_POST['comment']));	
		if (empty($_POST['comment'])) {
			$_POST['comment'] = "  ";
		}
		if ($arcadepermissions['canmakecomments']==1) {
			$DB_site->query("
				UPDATE " . TABLE_PREFIX . "gamesessions SET comment='$_POST[comment]' 
				WHERE sessionid=$lastsession[sessionid]
			");
		}
		
		$url = "arcade.php?do=scores&name=$lastsession[gamename]";
		eval(print_standard_redirect('redirect_updatethanks'));
	} else {
		print_no_permission();
	}
	$DB_site->free_result($lastsession);
}

// ############################ STATISTICS ################################
if ($_GET['do'] == "stats") {

	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_statistics'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');
	
	if ($arcadegeneral['challengescores'] == 1) {
		$sessionclause = "sessiontype IN (1,2)";
	} else {
		$sessionclause = "sessiontype=1";
	}
	
	globalize($_GET, array('userid'=>INT));
	
	if (!$_GET['userid']){
		$userid = $bbuserinfo['userid'];
	} else {
		$userid=$_GET['userid'];
	}
	if ($userid==0) {
		print_no_permission();
	}
	$user = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid=$userid");
	$activitycount = $DB_site->query("
										SELECT gamesessions.*, games.title FROM " . TABLE_PREFIX . "gamesessions AS gamesessions
										LEFT JOIN " . TABLE_PREFIX . "games AS games ON gamesessions.gamename = games.shortname
										WHERE userid=$userid AND valid=1 AND $sessionclause GROUP BY sessionid ORDER BY finish DESC");
	$played = $DB_site->num_rows($activitycount);
	$i = 1;
	while ($listscores = $DB_site->fetch_array($activitycount)) {
		if ($i<6){
			$scorelist .= $i.". <b><i>".$listscores['title']."</i></b>,  <b><i>".$listscores['score']."</i></b><br>";
			$i++;
		}
		$playtime = $playtime+($listscores['finish']-$listscores['start']);
		$ping += $listscores['ping'];
	}
	$DB_site->free_result($activitycount);
	if ($played!=0) {
		$ping = ceil($ping/$played);
	} else {
		$ping=0;
	}
	$awards = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "games WHERE highscorerid=$userid");
	while ($award = $DB_site->fetch_array($awards)) {
		if (!empty($award['miniimage'])) {
			$awardlist .= "<img src=\"$stylevar[imgdir_arcade]/".$award['miniimage']."\" border=0 align=\"absmiddle\"> ";
		}
		$awardlist .= "<b><i>  ".$award['title']."</i></b>, <b><i>".$award['highscore']."</i></b><br>";
	}
	$DB_site->free_result($awards);
	$playtime = ceil($playtime/60);
	if (fetch_avatar_url($user[userid]) != "") {
		$avatar = fetch_avatar_url($user[userid]);
		$user[avatar] = "<img src=\"".$avatar."\" border=0>";
	} else {
		$user[avatar] = "<img src=\"$stylevar[imgdir_arcade]/noavatar.gif\" border=0>";
	}
	$navbits = array("arcade.php?$session[sessionurl]" => "");
	$navbits[""] = " ";
	eval('$arcadebody = "' . fetch_template('arcade_statistics') . '";');
	$DB_site->free_result($user);
}

// ############################ EXTEND SESSION ################################
if ($_GET['do'] == "extendsession") {
// pre-cache templates used by all actions
$globaltemplates = array();
require_once('./global.php');

	echo "<META HTTP-EQUIV=Refresh CONTENT=\"350; URL=".$vboptions['bburl']."/arcade.php?do=extendsession\">";
	exit;
}

// ############################ NEW CHALLENGE ################################
if ($_GET['do'] == "newchallenge") {
	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_newchallenge'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');
	
	if (!isset($_GET['userid'])||$bbuserinfo['userid']==0 || ($_GET['userid']==$bbuserinfo['userid'])) {
		print_no_permission();	
	}
	
	globalize($_GET, array('userid'=>INT));
	$user = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid=$userid");
	$games = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "games");
	$avatar = fetch_avatar_url($user[userid]);
	if ($avatar != '') {
		$user[avatar] = "<img src=\"".$avatar."\" border=0 align=\"absmiddle\">";
	} else {
		$user[avatar] = "<img src=\"$stylevar[imgdir_arcade]/noavatar.gif\" border=0 align=\"absmiddle\">";
	}
	$avatar = fetch_avatar_url($bbuserinfo[userid]);
	if ($avatar != '') {
		$bbuserinfo[avatar] = "<img src=\"".$avatar."\" border=0 align=\"absmiddle\">";
	} else {
		$bbuserinfo[avatar] = "<img src=\"$stylevar[imgdir_arcade]/noavatar.gif\" border=0 align=\"absmiddle\">";
	}
	
	$activitycount = $DB_site->query("SELECT COUNT(valid=1) AS played,userid FROM " . TABLE_PREFIX . "gamesessions GROUP BY userid");
	while ($acount = $DB_site->fetch_array($activitycount)) {
		if ($bbuserinfo['userid']==$acount['userid']){
			$bbuserinfo['played'] = $acount['played'];
		} else {
			$user['played'] = $acount['played'];
		}
	}
	$DB_site->free_result($activitycount);
	// creates a $gamesettings array, usage $gamesettings[gamename]
	$result_gamesettings = $DB_site->query("SELECT gameid, shortname, gamesettings FROM " . TABLE_PREFIX . "games");
	while ($gameset = $DB_site->fetch_array($result_gamesettings)) {
		$gamesettings[$gameset[shortname]] = convert_bits_to_array($gameset[gamesettings],$_GAMESCHECK);
	}
	$DB_site->free_result($result_gamesettings);

	
	while ($game = $DB_site->fetch_array($games)) {
		if (($game['gamesettings'] & 1)&&($game['gamesettings'] & 8)) {
			$options .= "<option value=\"".$game['gameid']."\">".addslashes($game[title])."</option>";
		}
	}
	$DB_site->free_result($games);
	
	$navbits = array("arcade.php?$session[sessionurl]" => "");
	$navbits[""] = "  ";
		
	eval('$arcadebody = "' . fetch_template('arcade_newchallenge') . '";');
	$DB_site->free_result($user);
}

// ############################ DO NEW CHALLENGE ################################
if ($_POST['do'] == "donewchallenge") {
	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_donewchallenge',
		'arcade_pm'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');
	
	$navbits = array("arcade.php?$session[sessionurl]" => "");
	$navbits[""] = "New Challenge Submitted";

	globalize($_POST, array('userid'=>INT, 'gameid'=>INT));
	
	$user = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid=$userid");
	$game = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "games WHERE gameid=$gameid");

	$existingchallenges = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "gamechallenges WHERE challengerid=$bbuserinfo[userid] AND challengedid=$userid AND game='$game[shortname]' AND type<>5 AND status NOT IN (1,3)");
	if ($DB_site->num_rows($existingchallenges) != 0) {
		$existingchallenge = true;
	} else {
		$nowstamp = mktime();
		$DB_site->query("INSERT INTO " . TABLE_PREFIX . "gamechallenges (type,challengerid,challengedid,game,status,datestamp) VALUES(1,$bbuserinfo[userid],$user[userid],'$game[shortname]',0, $nowstamp)");
	}
	
	$chal['title'] = $bbuserinfo['username']."       ".$game['title']."!";
	$arcadepm = 3;
	eval('$pmmessage .= "' . fetch_template('arcade_pm') . '";');
	sendarcadepm($user['userid'],$user['username'],$bbuserinfo['userid'],$bbuserinfo['username'],$chal['title'],$pmmessage);		
	eval('$arcadebody = "' . fetch_template('arcade_donewchallenge') . '";');
	$DB_site->free_result($user);
	$DB_site->free_result($game);
}

// ############################ DECLINE CHALLENGE ################################
if ($_GET['do'] == "declinechallenge") {
	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_pm'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');

	globalize($_GET, array('id'=>INT));
	$validcount = $DB_site->query("
		SELECT gamechallenges.*, user.username, user.userid, games.title FROM " . TABLE_PREFIX . "gamechallenges AS gamechallenges
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON gamechallenges.challengerid = user.userid
		LEFT JOIN " . TABLE_PREFIX . "games AS games ON gamechallenges.game = games.shortname
		WHERE challengedid=$bbuserinfo[userid] AND challengeid=$id AND gamechallenges.status=0
	");
	$valid = $DB_site->num_rows($validcount);
	if ($valid==1) {
		$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET status=1 WHERE challengeid=$id");

		$challenge = $DB_site->fetch_array($validcount, DBARRAY_ASSOC);		

		$chal['title'] = $bbuserinfo['username']." has declined your challenge for a game of ".$challenge['title'];
				
		$arcadepm = 4;
		eval('$pmmessage .= "' . fetch_template('arcade_pm') . '";');
		sendarcadepm($challenge['userid'],$challenge['username'],$bbuserinfo['userid'],$bbuserinfo['username'],$chal['title'],$pmmessage);		
	
		header("Location: arcade.php");
	} else {
		print_no_permission();
	}
	$DB_site->free_result($validcount);
}

// ############################ ACCEPT CHALLENGE ################################
if ($_GET['do'] == "acceptchallenge") {
	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_play'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');
	
	$navbits = array("arcade.php?$session[sessionurl]" => "");
	$navbits[""] = " ";

	globalize($_GET, array('id'=>INT));
	$validcount = $DB_site->query("
		SELECT gamechallenges.*, user.username, user.userid, games.title, games.shortname, user2.username AS username2, user2.userid AS userid2 FROM " . TABLE_PREFIX . "gamechallenges AS gamechallenges
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON gamechallenges.challengerid = user.userid
		LEFT JOIN " . TABLE_PREFIX . "user AS user2 ON gamechallenges.challengedid = user2.userid
		LEFT JOIN " . TABLE_PREFIX . "games AS games ON gamechallenges.game = games.shortname
		WHERE (challengedid=$bbuserinfo[userid] AND gamechallenges.status=0 AND type=1 AND challengeid=$id) OR (challengerid=$bbuserinfo[userid] AND gamechallenges.status=2 AND type=3 AND challengeid=$id)
	");
	$valid = $DB_site->num_rows($validcount);
	if ($valid==1) {
		$challenge = $DB_site->fetch_array($validcount, DBARRAY_ASSOC);
		// Stops unauthorised users from gaining access to the arcade
		if (($arcadegeneral['quickreg']==1)&&($bbuserinfo['userid']==0)) {
			eval(print_standard_error('error_quickreg_prompt'));
		}
		
		// Prints the "no permission" page if gameid doesn't exist, isn't valid,
		// or if the user's usergroup has no permission
		if ($arcadepermissions['canplayarcade']==0) {
			print_no_permission();
		}
		
		// creates a $gamesettings array, usage $gamesettings[gamename]
		$result_gamesettings = $DB_site->query("SELECT gameid, shortname, gamesettings FROM " . TABLE_PREFIX . "games");
		while ($gameset = $DB_site->fetch_array($result_gamesettings)) {
			$gamesettings[$gameset[shortname]] = convert_bits_to_array($gameset[gamesettings],$_GAMESCHECK);
		}
		$DB_site->free_result($result_gamesettings);
		
		$thisGame = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "games WHERE shortname='$challenge[shortname]'");
		
		if ($gamesettings[$thisGame[shortname]]['active'] == 0) {
			print_no_permission();
		}
		if ($challenge['status']==0) {
			$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET status=10,type=2 WHERE challengeid=$challenge[challengeid]");
		} elseif ($challenge['status']==2) {
			$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET status=20,type=4 WHERE challengeid=$challenge[challengeid]");
		}
		eval('$arcadebody = "' . fetch_template('arcade_play') . '";');
		$DB_site->free_result($thisGame);
	} else {
		print_no_permission();
	}
	$DB_site->free_result($validcount);
	$dudcount = $DB_site->query("
		SELECT * FROM " . TABLE_PREFIX . "gamechallenges
		WHERE (challengedid=$bbuserinfo[userid] AND status=10 AND type=3) OR (challengerid=$bbuserinfo[userid] AND status=20 AND type=5)
	");
	$numduds = $DB_site->num_rows($dudcount);
	if ($numduds>=1) {
		$challenge2 = $DB_site->fetch_array($validcount, DBARRAY_ASSOC);
		if ($challenge2['status']==20 && $challenge2['type']==5) {
			$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET status=3 WHERE challengeid=$challenge2[challengeid]");
		}
		if ($challenge2['status']==10 && $challenge2['type']==3) {
			$DB_site->query("UPDATE " . TABLE_PREFIX . "gamechallenges SET status=2 WHERE challengeid=$challenge2[challengeid]");
		}
	}
	$DB_site->free_result($dudcount);
}

// ############################ CHALLENGES OVERVIEW ################################
if ($_GET['do'] == "challenges") {
	// pre-cache templates used by all actions
	$globaltemplates = array(
		'ARCADE',
		'arcade_header',
		'arcade_challenge_bit',
		'arcade_challenges'
	);
	require_once('./global.php');
	require_once('./includes/functions_user.php');
	require_once('./includes/functions_arcade.php');
	
	$navbits = array("arcade.php?$session[sessionurl]" => "");
	$navbits[""] = " ";

	$challenges = $DB_site->query("
	SELECT gamechallenges.*, games.title, games.miniimage AS icon, games.gameid, user.userid, user.username, user2.userid AS userid2, user2.username AS username2, user.usertitle AS usertitle, user2.usertitle AS usertitle2, gamechallenges.challengersession, gamechallenges.challengedsession FROM " . TABLE_PREFIX . "gamechallenges AS gamechallenges
	LEFT JOIN " . TABLE_PREFIX . "user AS user ON gamechallenges.challengerid = user.userid
	LEFT JOIN " . TABLE_PREFIX . "user AS user2 ON gamechallenges.challengedid = user2.userid
	LEFT JOIN " . TABLE_PREFIX . "games AS games ON games.shortname = gamechallenges.game
	WHERE gamechallenges.type=5 AND gamechallenges.status=3
	ORDER BY datestamp DESC LIMIT 10
	");
	
	$loser = "!";
	$winner = "!";
	$tied = "";
	
	$scorequery = $DB_site->query("
		SELECT gamechallenges.challengeid, gamechallenges.challengersession, gamechallenges.challengedsession FROM " . TABLE_PREFIX . "gamechallenges AS gamechallenges
		WHERE gamechallenges.type=5 AND gamechallenges.status=3
		ORDER BY datestamp DESC LIMIT 10
	");
	
	while ($scoreident = $DB_site->fetch_array($scorequery)) {
		if ($scoreident['challengersession']!=0) {
			$scoreSQL[] = "sessionid=$scoreident[challengersession]";
		}
		if ($scoreident['challengedsession']!=0) {
			$scoreSQL[] = "sessionid=$scoreident[challengedsession]";
		}
	}
	$DB_site->free_result($scoreQuery);
	
	if(!empty($scoreSQL)) {
		$whereclause = "WHERE (".implode(' OR ', $scoreSQL).") AND valid=1 AND sessiontype=2";
	}
	
	$scorecache = $DB_site->query("SELECT score,sessionid FROM " . TABLE_PREFIX . "gamesessions $whereclause");
	while ($scores = $DB_site->fetch_array($scorecache)) {
		$score[$scores[sessionid]] = $scores['score'];
	}
	$DB_site->free_result($scorecache);

	while ($challenge = $DB_site->fetch_array($challenges)) {
		if (empty($score[$challenge[challengersession]])) {
			$challenge['score']=0;
		} else {
			$challenge['score']=$score[$challenge[challengersession]];
		}
		if (empty($score[$challenge[challengedsession]])) {
			$challenge['score2']=0;
		} else {
			$challenge['score2']=$score[$challenge[challengedsession]];
		}
		
		if ($challenge['score2']>$challenge['score']) {
			$challenge['result']=$loser;
			$challenge['result2']=$winner;
		} elseif ($challenge['score2']<$challenge['score']){
			$challenge['result2']=$loser;
			$challenge['result']=$winner;
		} else {
			$challenge['result2']=$tied;
			$challenge['result']=$tied;
		}
		
		if ($list!=true) {
			$avatar = fetch_avatar_url($challenge[userid]);
			if ($avatar != '') {
				$challenge[avatar] = "<img src=\"".$avatar."\" border=0 align=\"absmiddle\">";
			} else {
				$challenge[avatar] = "<img src=\"$stylevar[imgdir_arcade]/noavatar.gif\" border=0 align=\"absmiddle\">";
			}
			$avatar = fetch_avatar_url($challenge[userid2]);
			if ($avatar != '') {
				$challenge[avatar2] = "<img src=\"".$avatar."\" border=0 align=\"absmiddle\">";
			} else {
				$challenge[avatar2] = "<img src=\"$stylevar[imgdir_arcade]/noavatar.gif\" border=0 align=\"absmiddle\">";
			}
		}
		$date = vbdate("g:ia M j",$challenge['datestamp']);
		eval('$challengebits .= "' . fetch_template('arcade_challenge_bit') . '";');
		$list = true;
		exec_switch_bg();
	}
	$DB_site->free_result($challenges);
	eval('$arcadebody = "' . fetch_template('arcade_challenges') . '";');
}

// Stops unauthorised users from gaining access to the arcade
if (!($permissions['arcadepermissions'] & CANVIEWARCADE)) {
	print_no_permission();
}

// Shows a nopermission if the arcade is closed
if ($arcadegeneral['active'] == 0) {
	print_no_permission();
}

// Other options and checks
if ($arcadegeneral['netplay'] == 1) {
// -----------------------------------------------------------------------
// INSERT NETPLAY PLUGIN CODE HERE
// -----------------------------------------------------------------------

// -----------------------------------------------------------------------
// INSERT NETPLAY PLUGIN CODE HERE
// -----------------------------------------------------------------------
}

$navbits = construct_navbits($navbits);
eval('$navbar = "' . fetch_template('navbar') . '";');
// Arcade header template
eval('$arcadeheader = "' . fetch_template('arcade_header') . '";');
eval('print_output("' . fetch_template('ARCADE') . '");');

?>